/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.xebialabs.xltest.api.requests.ImportTestResultsRequest;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.service.ExecutableAlreadyRunningException;
import com.xebialabs.xltest.service.ImportService;
import com.xebialabs.xltest.service.execution.TestSpecificationExecutor;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/import")
@Produces(value={"application/json"})
@NoCache
public class ImportControllerInternal {
    private static final Logger LOG = LoggerFactory.getLogger(ImportControllerInternal.class);
    private final TestSpecificationRepository testSpecifications;
    private final ImportService importService;
    private final TestSpecificationExecutor testSpecificationExecutor;

    @Autowired
    public ImportControllerInternal(TestSpecificationRepository testSpecificationRepository, ImportService importService, TestSpecificationExecutor testSpecificationExecutor) {
        this.testSpecifications = testSpecificationRepository;
        this.importService = importService;
        this.testSpecificationExecutor = testSpecificationExecutor;
    }

    @POST
    @Path(value="/{testSpecificationId:.+}")
    @Consumes(value={"multipart/mixed"})
    public Response importTestResultsSentByJenkins(@PathParam(value="testSpecificationId") String testSpecificationId, MultipartInput parts, @Context HttpServletRequest request) throws Exception {
        try (ImportTestResultsRequest importTestResultsRequest = new ImportTestResultsRequest(parts);){
            importTestResultsRequest.validateMetadata();
            LOG.info("Received import for testSpecificationId={}", (Object)testSpecificationId);
            Map<String, Object> enrichedMetadata = this.buildJenkinsCiEventData(importTestResultsRequest.getMetadata());
            InputStream inputStream = importTestResultsRequest.getInputStream();
            JSONObject result = (JSONObject)this.importService.importTestResultsFromZIPInputStream(testSpecificationId, inputStream, enrichedMetadata).map(this::makeJsonResponse).toBlocking().first();
            Response response = Response.ok((Object)result.toString()).build();
            return response;
        }
    }

    private JSONObject makeJsonResponse(List<String> testRunIds) {
        try {
            JSONObject resp = new JSONObject();
            resp.put("testRunId", testRunIds);
            return resp;
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not form JSON", e);
        }
    }

    @GET
    @Path(value="/{testSpecificationId:.+}")
    @Consumes(value={"application/json"})
    public Response getTestRun(@PathParam(value="testSpecificationId") String testSpecificationId, @Context HttpServletResponse response) throws Exception {
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Connection", "keep-alive");
        ActiveTestSpecification testSpecification = this.testSpecifications.getActiveTestSpecificationById(testSpecificationId);
        try {
            String runId = this.testSpecificationExecutor.importAllAvailableResults(testSpecification);
            return Response.ok((Object)("{ \"taskId\": \"" + runId + "\"}")).build();
        }
        catch (ExecutableAlreadyRunningException re) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)re.getMessage()).build();
        }
    }

    private String getRequiredValue(Map<String, Object> data, String key) {
        return this.getValue(data, key, Collections.emptySet(), true);
    }

    private String getRequiredValue(Map<String, Object> data, String key, Set<String> expected) {
        return this.getValue(data, key, expected, true);
    }

    private String getValue(Map<String, Object> data, String key, Set<String> expected, boolean required) {
        try {
            String value = (String)data.get(key);
            if (required && value == null) {
                LOG.debug("data ({}) did not contain required key {}", data, (Object)key);
                throw new IllegalArgumentException(String.format("expected a value for [%s] in request", key));
            }
            if (!expected.isEmpty() && !expected.contains(value)) {
                throw new IllegalArgumentException(String.format("expected one of [%s] for [%s] in request", expected.toString(), key));
            }
            data.remove(key);
            return value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("unexpected value while looking up [%s] in request: %s", key, e.getMessage()));
        }
    }

    private String capitalize(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    @VisibleForTesting
    Map<String, Object> buildJenkinsCiEventData(Map<String, Object> originalInput) {
        String[] requiredProperties;
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.putAll(originalInput);
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("ciSource", this.getRequiredValue(input, "source"));
        eventData.put("ciBuildResult", this.getRequiredValue(input, "buildResult", Sets.newHashSet((Object[])new String[]{"SUCCESS", "FAILURE"})));
        for (String property : requiredProperties = new String[]{"serverUrl", "buildNumber", "jobUrl", "jobName", "buildUrl", "executedOn"}) {
            String eventKey = "ci" + this.capitalize(property);
            eventData.put(eventKey, this.getRequiredValue(input, property));
        }
        if (input.containsKey("buildParameters")) {
            Map buildParameters = (Map)input.get("buildParameters");
            for (Map.Entry entry : buildParameters.entrySet()) {
                eventData.put("buildParameter" + this.capitalize((String)entry.getKey()), entry.getValue());
            }
            input.remove("buildParameters");
        }
        if (!input.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Unexpected extra properties encountered in import request: ");
            for (Map.Entry entry : input.entrySet()) {
                message.append("[");
                message.append((String)entry.getKey());
                message.append("=");
                message.append(entry.getValue().toString());
                message.append("]\n");
            }
            throw new IllegalArgumentException(message.toString());
        }
        return eventData;
    }
}

