/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.api.internal.ExecuteController;
import com.xebialabs.xltest.domain.TestRunImpl;
import com.xebialabs.xltest.view.ExecutionParameters;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/rerun")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class RerunController {
    private final TestRunsRepository testRunsRepository;
    private final ExecuteController executeController;

    @Autowired
    public RerunController(TestRunsRepository testRunsRepository, ExecuteController executeController) {
        this.testRunsRepository = testRunsRepository;
        this.executeController = executeController;
    }

    @GET
    @Path(value="/{runId}/{suite}")
    public Response rerun(@PathParam(value="runId") String runId, @PathParam(value="suite") String suite) throws Exception {
        TestRun testRun = this.testRunsRepository.getTestRun(runId);
        String testSpecificationName = testRun.getTestSpecificationName();
        ExecutionParameters executionParameters = new ExecutionParameters(((TestRunImpl)testRun).getParameters());
        Map<String, Object> parameters = executionParameters.getParameters();
        parameters.put("suiteName", suite);
        return this.executeController.execute(testSpecificationName, executionParameters, true);
    }
}

