/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.repository.EventRepository;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/test")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class TestController {
    private static final Logger LOG = LoggerFactory.getLogger(TestController.class);
    private final TestRunsRepository testRunsRepository;
    private final EventRepository eventRepository;

    @Autowired
    public TestController(TestRunsRepository testRunsRepository, EventRepository eventRepository) {
        this.testRunsRepository = testRunsRepository;
        this.eventRepository = eventRepository;
    }

    @GET
    @Path(value="/{testRunId:[\\w-]+}")
    public String getTestRun(@PathParam(value="testRunId") String testRunId) {
        TreeMap<String, Boolean> resultObject = new TreeMap<String, Boolean>();
        TestRun testRun = this.testRunsRepository.getTestRun(testRunId);
        resultObject.put("running", !testRun.isFinished());
        if (testRun.isFinished()) {
            resultObject.put("qualification", testRun.getQualificationResult());
        }
        return JsonProviderFactory.createProvider().toJson(resultObject);
    }

    @POST
    @Path(value="/{testSpecificationId}/{testRunId:.+}")
    public Response receiveEvent(@Context HttpServletRequest request, @PathParam(value="testSpecificationId") String testSpecificationId, @PathParam(value="testRunId") String testRunId, Event event) {
        LOG.info("Received event {} for run {}", (Object)event.getType(), (Object)testRunId);
        this.eventRepository.insert(new Event(event, Event.props((Object[])new Object[]{"@runId", testRunId, "@createdAt", System.currentTimeMillis(), "@testSpecification", testSpecificationId, "_host", request.getRemoteHost()})));
        return Response.ok().build();
    }
}

