/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.v1;

import com.xebialabs.xltest.api.v1.dto.ProjectRequest;
import com.xebialabs.xltest.api.v1.dto.ProjectResponse;
import com.xebialabs.xltest.domain.Project;
import com.xebialabs.xltest.serialize.CiDepth;
import com.xebialabs.xltest.service.ProjectService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/v1/projects")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class ProjectController {
    private final ProjectService projectService;

    @Autowired
    public ProjectController(ProjectService projectService) {
        this.projectService = projectService;
    }

    @GET
    @Path(value="/")
    @CiDepth(value=1)
    public Response getProjects(@QueryParam(value="title") String title) {
        List<Project> projects = this.projectService.getProjects(title);
        return Response.status((int)200).entity(projects.stream().sorted(Project.titleComparator).map(ProjectResponse::createFrom).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/{projectId}")
    public Response getProject(@PathParam(value="projectId") String projectId) throws URISyntaxException {
        Project project = this.projectService.getProject(projectId);
        return this.singleProjectResponse(project, 200);
    }

    @POST
    @Path(value="/")
    public Response createProject(ProjectRequest item) throws URISyntaxException {
        Project project = this.projectService.createProject(item);
        return this.singleProjectResponse(project, 201);
    }

    @PUT
    @Path(value="/{projectId}")
    public Response updateProject(@PathParam(value="projectId") String projectId, @HeaderParam(value="ETag") String eTag, ProjectRequest projectRequest) throws URISyntaxException {
        Project project = this.projectService.updateProject(projectId, projectRequest, eTag);
        return this.singleProjectResponse(project, 200);
    }

    private Response singleProjectResponse(Project project, int status) throws URISyntaxException {
        return Response.status((int)status).header("ETag", (Object)project.get$token()).entity((Object)ProjectResponse.createFrom(project)).location(new URI(String.format("%s/projects/%s", "/api/v1", project.getName()))).build();
    }

    @DELETE
    @Path(value="/{projectId}")
    public Response deleteProject(@PathParam(value="projectId") String projectId, @QueryParam(value="force") boolean force, @HeaderParam(value="ETag") String eTag) {
        this.projectService.deleteProject(projectId, force, eTag);
        return Response.noContent().build();
    }
}

