/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.v1;

import com.google.common.base.Strings;
import com.xebialabs.xltest.service.TestSpecificationService;
import java.util.LinkedHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/v1/qualifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class QualificationController {
    public static final String MESSAGE = "message";
    public static final String RESULT = "result";
    private static final String STATUS = "status";
    private final TestSpecificationService testSpecificationService;

    @Autowired
    public QualificationController(TestSpecificationService testSpecificationService) {
        this.testSpecificationService = testSpecificationService;
    }

    @Path(value="/")
    @GET
    public Response getQualificationByName(@QueryParam(value="testSpecification") String testSpecification, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)testSpecification)) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            result.put(MESSAGE, "A test specification is required in the testSpecification query parameter");
            result.put(STATUS, "400");
            result.put("error_code", "object.not.found");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(result).build();
        }
        return this.testSpecificationService.getQualificationForTestSpec(testSpecification);
    }
}

