/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.elasticsearch;

import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchUtil.class);

    public static void ensureGreen(Client client, TimeValue timeout) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)client.admin().cluster().health(Requests.clusterHealthRequest((String[])new String[]{"_all"}).timeout(timeout).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForRelocatingShards(0)).actionGet();
        if (actionGet.isTimedOut()) {
            LOG.error("Timeout waiting for green cluster state, cluster state:\n{}\n{}", (Object)((ClusterStateResponse)client.admin().cluster().prepareState().get()).getState().prettyPrint(), (Object)((PendingClusterTasksResponse)client.admin().cluster().preparePendingClusterTasks().get()).prettyPrint());
            throw new RuntimeException("Timed out waiting for Elasticsearch green state");
        }
        if (!actionGet.getStatus().equals((Object)ClusterHealthStatus.GREEN)) {
            LOG.error("Cluster state is {}", (Object)actionGet.getStatus());
            throw new RuntimeException("Elasticsearch cluster state did not become green");
        }
    }
}

