/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize.exceptionmappers;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xltest.serialize.exceptionmappers.AbstractExceptionMapper;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class ValidationsFailedExceptionMapper
extends AbstractExceptionMapper
implements ExceptionMapper<Validator.ValidationsFailedException> {
    public Response toResponse(Validator.ValidationsFailedException exception) {
        Map<String, Object> response = this.getBaseResponse();
        if (exception.hasEntity()) {
            Object entity = exception.getEntity();
            if (entity instanceof ConfigurationItem) {
                ConfigurationItem ci = (ConfigurationItem)entity;
                response.put("message", this.makeErrorMessage(ci));
                response.put("validationMessages", ci.get$validationMessages());
            } else {
                response.put("message", exception.getMessage());
            }
        } else {
            response.put("message", exception.getMessage());
        }
        response.put("status", 422);
        response.put("error_code", "illegal.argument");
        return Response.status((int)422).type("application/json").entity(response).build();
    }

    private String makeErrorMessage(ConfigurationItem ci) {
        StringBuilder builder = new StringBuilder("Validation errors. ");
        boolean isFirst = true;
        for (ValidationMessage validationMessage : ci.get$validationMessages()) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(validationMessage.getPropertyName()).append(": ").append(validationMessage.getMessage());
            isFirst = false;
        }
        return builder.toString();
    }
}

