/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.ImportFailedException;
import com.xebialabs.xlt.plugin.api.resultparser.NothingToImportException;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParser;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParserDriver;
import com.xebialabs.xlt.plugin.api.resultparser.UnexpectedFormatException;
import com.xebialabs.xlt.plugin.api.testrun.DuplicateHierarchyException;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.EventValidator;
import com.xebialabs.xlt.plugin.api.testrun.InvalidEventException;
import com.xebialabs.xlt.plugin.api.testrun.InvalidRunException;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.TestToolFactory;
import com.xebialabs.xltest.domain.TestToolNameAware;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.service.ConcurrentImportException;
import com.xebialabs.xltest.utils.FileUtil;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.Globbit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;
import rx.Observable;

@Component
public class ImportService {
    private static final Logger LOG = LoggerFactory.getLogger(ImportService.class);
    private final TestToolRepository testToolRepository;
    private final EventRepository eventRepository;
    private final TestRunsRepository testRunsRepository;
    private final TestSpecificationRepository testSpecificationRepository;
    private final ConcurrentHashMap<String, AtomicBoolean> currentlyImporting = new ConcurrentHashMap();

    @Autowired
    public ImportService(TestToolRepository testToolRepository, TestRunsRepository testRunsRepository, EventRepository eventRepository, TestSpecificationRepository testSpecificationRepository) {
        this.testToolRepository = testToolRepository;
        this.testRunsRepository = testRunsRepository;
        this.eventRepository = eventRepository;
        this.testSpecificationRepository = testSpecificationRepository;
    }

    public Observable<List<String>> importTestResultsFromZIPInputStream(String testSpecificationId, InputStream inputStreamWithZippedData, Map<String, Object> metaData) {
        return Observable.just((Object)inputStreamWithZippedData).map(is -> {
            try {
                return FileUtil.extractZipInputStreamToTempLocalTempDirectory(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to extract zip from input stream.", e);
            }
        }).map(tempDir -> {
            try {
                List<String> list = this.importTestResults(testSpecificationId, LocalFile.valueOf((File)tempDir), metaData);
                return list;
            }
            catch (UnexpectedFormatException ufe) {
                throw new UnexpectedFormatException(ufe.getMessage(), (Collection)ufe.getFiles(), Optional.of(tempDir.getAbsolutePath()));
            }
            finally {
                FileSystemUtils.deleteRecursively((File)tempDir);
            }
        });
    }

    public List<String> importTestResults(String testSpecificationId, OverthereFile resultsSearchRoot, Map<String, Object> metadata) throws ImportException {
        BaseTestSpecification testSpecification = this.testSpecificationRepository.getById(testSpecificationId);
        LOG.debug("importTestResults(spec={})", (Object)testSpecification.getName());
        if (testSpecification instanceof TestToolNameAware) {
            FileMatcher fileMatcher = new FileMatcher("**/*");
            return this.importTestResultsIfNotAlreadyImporting(testSpecification, resultsSearchRoot, fileMatcher, metadata);
        }
        throw new IllegalArgumentException("Can only import results from test specifications that are TestToolNameAware!");
    }

    public List<String> importTestResults(ActiveTestSpecification testSpecification, String testRunId, OverthereFile resultsSearchRoot) throws ImportException {
        LOG.debug("importTestResults(spec={})", (Object)testSpecification.getName());
        FileMatcher fileMatcher = new FileMatcher(testSpecification.getSearchPattern());
        return this.importTestResults(testSpecification, resultsSearchRoot, fileMatcher, Collections.emptyMap());
    }

    private SortedSet<OverthereFile> globFiles(OverthereFile root, FileMatcher matcher, Globbit.GlobMode globMode) throws NothingToImportException {
        SortedSet<OverthereFile> overthereFiles = Globbit.find(root, matcher, globMode);
        if (overthereFiles.isEmpty()) {
            throw new NothingToImportException(String.format("No test results found in '%s' with pattern '%s'", root, matcher));
        }
        return overthereFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> importTestResultsIfNotAlreadyImporting(BaseTestSpecification testSpecification, OverthereFile resultsSearchRoot, FileMatcher fileMatcher, Map<String, Object> metadata) throws ImportException {
        if (!this.setImporting(testSpecification.getId())) {
            throw new ConcurrentImportException();
        }
        try {
            List<String> list = this.importTestResults(testSpecification, resultsSearchRoot, fileMatcher, metadata);
            return list;
        }
        finally {
            this.currentlyImporting.get(testSpecification.getId()).set(false);
            if (resultsSearchRoot != null) {
                resultsSearchRoot.getConnection().close();
            }
        }
    }

    private List<String> importTestResults(BaseTestSpecification testSpecification, OverthereFile resultsSearchRoot, FileMatcher fileMatcher, Map<String, Object> metadata) throws ImportException {
        List runs;
        LOG.debug("importTestResults(testSpecId={})", (Object)testSpecification.getName());
        TestToolFactory scriptableTestTool = this.testToolRepository.findTestToolConfigurationByName(((TestToolNameAware)((Object)testSpecification)).getTestToolName());
        TestResultParser testResultParser = scriptableTestTool.create(testSpecification, resultsSearchRoot, this.eventRepository);
        TestResultParserDriver testResultParserDriver = new TestResultParserDriver(testResultParser);
        SortedSet<OverthereFile> filesToImport = this.globFiles(resultsSearchRoot, fileMatcher, scriptableTestTool.getGlobMode());
        LOG.debug("Found {} files to import. Sending them to the runner", (Object)filesToImport.size());
        try {
            runs = testResultParserDriver.run(filesToImport, testSpecification.getName());
        }
        catch (UnexpectedFormatException ufe) {
            String s = this.enhanceExceptionWithTestParserInfo(scriptableTestTool, ufe);
            throw new UnexpectedFormatException(s, (Collection)ufe.getFiles(), Optional.empty());
        }
        if (runs.isEmpty()) {
            throw new NothingToImportException("No new test results are found.");
        }
        ArrayList<String> importedTestRunIds = new ArrayList<String>();
        try {
            for (List run : runs) {
                this.enrichEventsWithCustomMetaData(run, metadata);
                EventValidator.validateRun((List)run);
                this.eventRepository.insert(run);
                importedTestRunIds.add(((Event)run.get(0)).getTestRunId());
            }
            for (List run : runs) {
                this.qualifyRun(testSpecification, run);
            }
            return importedTestRunIds;
        }
        catch (DuplicateHierarchyException e) {
            LOG.error("Attempt to import test run with duplicate hierarchy: {}, this is probably a problem in the imported results.", (Object)e.getHierarchy());
            this.cleanUpTestRuns(importedTestRunIds);
            throw new ImportFailedException(String.format("Error while importing test results: Some tests have a duplicate hierarchy (fully qualified name): %s", e.getHierarchy().toString()));
        }
        catch (InvalidRunException e) {
            LOG.error("Attempt to import invalid test run", (Throwable)e);
            this.cleanUpTestRuns(importedTestRunIds);
            throw new ImportFailedException(String.format("Error while importing test results: %s", e.getMessage()), (Throwable)e);
        }
        catch (InvalidEventException e) {
            LOG.error("Attempt to import test run with invalid event", (Throwable)e);
            this.cleanUpTestRuns(importedTestRunIds);
            throw new ImportFailedException(String.format("Error while importing test results: the test run contained an invalid event (%s)", e.getEvent()), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error("Problem importing test run", (Throwable)e);
            this.cleanUpTestRuns(importedTestRunIds);
            throw new ImportFailedException(String.format("Error while importing test results: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void cleanUpTestRuns(List<String> testRunIds) {
        LOG.debug("Cleaning up test runs after error: {}", testRunIds);
        TermsFilterBuilder runIdsFilter = FilterBuilders.termsFilter((String)"@runId", testRunIds);
        this.eventRepository.delete((FilterBuilder)runIdsFilter).actionGet();
    }

    private String enhanceExceptionWithTestParserInfo(TestToolFactory scriptableTestTool, UnexpectedFormatException ufe) {
        String firstFile = (String)ufe.getFiles().get(0);
        if (ufe.getFiles().size() > 1) {
            firstFile = firstFile + String.format(" and %s other files", ufe.getFiles().size() - 1);
        }
        return String.format("Unable to parse result files (%s). This parser is for test tool %s. Are you sure that this is the correct type?", firstFile, scriptableTestTool.getDescription());
    }

    private void qualifyRun(BaseTestSpecification testSpecification, List<Event> run) {
        Qualification qualification = testSpecification.getQualification();
        if (qualification != null) {
            Qualifier qualifier = qualification.getQualifier(testSpecification, run.get(0).getTestRunId(), this.testRunsRepository);
            QualificationResult qualificationResult = qualifier.getQualificationResult(run);
            this.testSpecificationRepository.addQualificationResult(qualificationResult);
        }
    }

    private void enrichEventsWithCustomMetaData(List<Event> events, Map<String, Object> metadata) {
        for (Event event : events) {
            event.updateWithProperties(metadata);
        }
    }

    private synchronized boolean setImporting(String testSpecId) {
        if (!this.currentlyImporting.containsKey(testSpecId)) {
            this.currentlyImporting.put(testSpecId, new AtomicBoolean(true));
            return true;
        }
        return this.currentlyImporting.get(testSpecId).compareAndSet(false, true);
    }
}

