/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service.execution;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ExecutableTestSpecification;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.service.ImportService;
import com.xebialabs.xltest.service.TestExecutionStateHolder;
import com.xebialabs.xltest.service.execution.TestSpecificationExecutionException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpecificationCallable
implements Callable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationCallable.class);
    private final ExecutableTestSpecification specification;
    private final String testRunId;
    private final Map<String, Object> parameters;
    private final CountDownLatch latch;
    private final EventHandler parentEventHandler;
    private final TestExecutionStateHolder testExecutionStateHolder;
    private final ImportService importService;

    public TestSpecificationCallable(ExecutableTestSpecification specification, String testRunId, Map<String, Object> parameters, CountDownLatch latch, EventHandler parentEventHandler, TestExecutionStateHolder testExecutionStateHolder, ImportService importService) {
        this.specification = specification;
        this.latch = latch;
        this.parameters = parameters;
        this.testRunId = testRunId;
        this.parentEventHandler = parentEventHandler;
        this.testExecutionStateHolder = testExecutionStateHolder;
        this.importService = importService;
    }

    protected String resolve(String commandLine, Map<String, Object> parameters) {
        if (commandLine == null || commandLine.equals("")) {
            return commandLine;
        }
        Template tmpl = Mustache.compiler().compile(commandLine);
        return tmpl.execute(parameters);
    }

    @Override
    public String call() throws Exception {
        try {
            this.testExecutionStateHolder.updateStartTime(this.specification.getName());
            LOG.debug("Calling execute on test specification {}", (Object)this.specification);
            String resolvedCommandline = this.resolve(this.specification.getCommandLine(), this.parameters);
            SimpleBindings binding = new SimpleBindings();
            binding.put("test_run_id", (Object)this.testRunId);
            binding.put("self", (Object)this.specification);
            binding.put("resolved_command_line", (Object)resolvedCommandline);
            binding.put("event_handler", (Object)new EventHandler(){

                @Override
                public void onReceive(Event event) throws Exception {
                    TestSpecificationCallable.this.parentEventHandler.onReceive(new Event(event, Event.props((Object[])new Object[]{"@testSpecification", TestSpecificationCallable.this.specification.getName()})));
                }
            });
            binding.put("parameters", (Object)(this.parameters == null ? new HashMap() : new HashMap<String, Object>(this.parameters)));
            ScriptedConfigurationItem scriptedConfigurationItem = new ScriptedConfigurationItem();
            scriptedConfigurationItem.setScriptLocation(this.specification.getScriptLocation());
            ScriptContext context = scriptedConfigurationItem.newScriptContext();
            context.setBindings(binding, 100);
            scriptedConfigurationItem.execute(context, this.specification);
            this.importService.importTestResults(this.specification, this.testRunId, this.specification.getRemotePath());
        }
        catch (ImportException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.error("Error while executing the test specification {}", (Object)this.specification, (Object)t);
            throw new TestSpecificationExecutionException(this.specification.getName(), "Exception while executing test specification", t);
        }
        finally {
            LOG.info("removing running task from local memory for specification {}", (Object)this.specification);
            if (this.latch != null) {
                this.latch.countDown();
            }
            this.testExecutionStateHolder.moveTaskToExpiredCache(this.specification.getName());
        }
        return this.specification.getName();
    }
}

