/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import com.typesafe.config.Config;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);

    private SecurityUtils() {
    }

    public static void configureTrustStore(Config config) {
        String trustStorePath = config.getString("xlt.truststore.location");
        String password = config.getString("xlt.truststore.password");
        if (!StringUtils.hasText((String)trustStorePath)) {
            return;
        }
        SecurityUtils.verifyTrustStore(trustStorePath, password);
        System.setProperty("javax.net.ssl.trustStore", trustStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", password);
    }

    private static void verifyTrustStore(String location, String password) {
        try (FileInputStream fis = new FileInputStream(location);){
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error("Failed to open trustStore", (Throwable)e);
            throw new RuntimeException("Failed to open trustStore", e);
        }
    }
}

