/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.spi.federation.DocumentChanges;
import org.modeshape.jcr.value.Name;

public class FederatedDocumentChanges
implements DocumentChanges {
    private final String documentId;
    private final Document document;
    private final FederatedPropertyChanges propertyChanges;
    private final FederatedMixinChanges mixinChanges;
    private final FederatedChildrenChanges childrenChanges;
    private final FederatedParentChanges parentChanges;
    private final FederatedReferrerChanges referrerChanges;

    protected FederatedDocumentChanges(String documentId, Document document) {
        this.document = document;
        this.documentId = documentId;
        this.propertyChanges = new FederatedPropertyChanges();
        this.mixinChanges = new FederatedMixinChanges();
        this.childrenChanges = new FederatedChildrenChanges();
        this.parentChanges = new FederatedParentChanges();
        this.referrerChanges = new FederatedReferrerChanges();
    }

    @Override
    public DocumentChanges.ChildrenChanges getChildrenChanges() {
        return this.childrenChanges;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public DocumentChanges.MixinChanges getMixinChanges() {
        return this.mixinChanges;
    }

    @Override
    public DocumentChanges.ParentChanges getParentChanges() {
        return this.parentChanges;
    }

    @Override
    public DocumentChanges.PropertyChanges getPropertyChanges() {
        return this.propertyChanges;
    }

    @Override
    public DocumentChanges.ReferrerChanges getReferrerChanges() {
        return this.referrerChanges;
    }

    protected void setPropertyChanges(Set<Name> sessionChangedProperties, Set<Name> sessionRemovedProperties) {
        HashSet<Name> addedProperties = new HashSet<Name>();
        Iterator<Name> changedPropertiesIterator = sessionChangedProperties.iterator();
        while (changedPropertiesIterator.hasNext()) {
            Name changedPropertyName = changedPropertiesIterator.next();
            if (!sessionRemovedProperties.contains(changedPropertyName)) {
                addedProperties.add(changedPropertyName);
                changedPropertiesIterator.remove();
                continue;
            }
            sessionRemovedProperties.remove(changedPropertyName);
        }
        this.propertyChanges.changed(sessionChangedProperties).removed(sessionRemovedProperties).added(addedProperties);
    }

    protected void setMixinChanges(Set<Name> addedMixins, Set<Name> removedMixins) {
        this.mixinChanges.added(addedMixins).removed(removedMixins);
    }

    protected void setChildrenChanges(LinkedHashMap<String, Name> sessionAppendedChildren, Map<String, Name> sessionRenamedChildren, Set<String> sessionRemovedChildren, Map<String, LinkedHashMap<String, Name>> sessionChildrenInsertedBeforeAnotherChild) {
        for (String orderedBefore : sessionChildrenInsertedBeforeAnotherChild.keySet()) {
            LinkedHashMap<String, Name> childrenMap = sessionChildrenInsertedBeforeAnotherChild.get(orderedBefore);
            for (String childId : childrenMap.keySet()) {
                sessionRemovedChildren.remove(childId);
            }
        }
        this.childrenChanges.appended(sessionAppendedChildren).renamed(sessionRenamedChildren).removed(sessionRemovedChildren).insertedBeforeAnotherChild(sessionChildrenInsertedBeforeAnotherChild);
    }

    protected void setParentChanges(Set<String> addedParents, Set<String> removedParents, String newPrimaryParent) {
        this.parentChanges.added(addedParents).removed(removedParents).newPrimaryParent(newPrimaryParent);
    }

    protected void setReferrerChanges(Set<String> addedWeakReferrers, Set<String> removedWeakReferrers, Set<String> addedStrongReferrers, Set<String> removedStrongReferrers) {
        this.referrerChanges.addedWeak(addedWeakReferrers).addedStrong(addedStrongReferrers).removedStrong(removedStrongReferrers).removedWeak(removedWeakReferrers);
    }

    protected class FederatedReferrerChanges
    implements DocumentChanges.ReferrerChanges {
        private Set<String> addedWeak = Collections.emptySet();
        private Set<String> removedWeak = Collections.emptySet();
        private Set<String> addedStrong = Collections.emptySet();
        private Set<String> removedStrong = Collections.emptySet();

        protected FederatedReferrerChanges() {
        }

        @Override
        public boolean isEmpty() {
            return this.addedWeak.isEmpty() && this.removedWeak.isEmpty() && this.addedStrong.isEmpty() && this.removedStrong.isEmpty();
        }

        @Override
        public Set<String> getAddedStrong() {
            return this.addedStrong;
        }

        @Override
        public Set<String> getAddedWeak() {
            return this.addedWeak;
        }

        @Override
        public Set<String> getRemovedStrong() {
            return this.removedStrong;
        }

        @Override
        public Set<String> getRemovedWeak() {
            return this.removedWeak;
        }

        private FederatedReferrerChanges addedStrong(Set<String> addedStrong) {
            if (addedStrong != null) {
                this.addedStrong = addedStrong;
            }
            return this;
        }

        private FederatedReferrerChanges addedWeak(Set<String> addedWeak) {
            if (addedWeak != null) {
                this.addedWeak = addedWeak;
            }
            return this;
        }

        private DocumentChanges.ReferrerChanges removedWeak(Set<String> removedWeak) {
            if (removedWeak != null) {
                this.removedWeak = removedWeak;
            }
            return this;
        }

        private FederatedReferrerChanges removedStrong(Set<String> removedStrong) {
            if (removedStrong != null) {
                this.removedStrong = removedStrong;
            }
            return this;
        }
    }

    protected class FederatedParentChanges
    implements DocumentChanges.ParentChanges {
        private Set<String> added = Collections.emptySet();
        private Set<String> removed = Collections.emptySet();
        private String newPrimaryParent = null;

        protected FederatedParentChanges() {
        }

        @Override
        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty() && StringUtil.isBlank((String)this.newPrimaryParent);
        }

        @Override
        public boolean hasNewPrimaryParent() {
            return !StringUtil.isBlank((String)this.newPrimaryParent);
        }

        @Override
        public Set<String> getAdded() {
            return this.added;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removed;
        }

        @Override
        public String getNewPrimaryParent() {
            return this.newPrimaryParent;
        }

        private FederatedParentChanges added(Set<String> added) {
            if (added != null) {
                this.added = added;
            }
            return this;
        }

        private FederatedParentChanges removed(Set<String> removed) {
            if (removed != null) {
                this.removed = removed;
            }
            return this;
        }

        private DocumentChanges.ParentChanges newPrimaryParent(String newPrimaryParent) {
            this.newPrimaryParent = newPrimaryParent;
            return this;
        }
    }

    protected class FederatedChildrenChanges
    implements DocumentChanges.ChildrenChanges {
        private LinkedHashMap<String, Name> appended = new LinkedHashMap();
        private Map<String, Name> renamed = Collections.emptyMap();
        private Map<String, LinkedHashMap<String, Name>> insertedBeforeAnotherChild = Collections.emptyMap();
        private Set<String> removed = Collections.emptySet();

        private FederatedChildrenChanges() {
        }

        @Override
        public boolean isEmpty() {
            return this.appended.isEmpty() && this.renamed.isEmpty() && this.insertedBeforeAnotherChild.isEmpty() && this.removed.isEmpty();
        }

        @Override
        public LinkedHashMap<String, Name> getAppended() {
            return this.appended;
        }

        @Override
        public Map<String, Name> getRenamed() {
            return this.renamed;
        }

        @Override
        public Map<String, LinkedHashMap<String, Name>> getInsertedBeforeAnotherChild() {
            return this.insertedBeforeAnotherChild;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removed;
        }

        private FederatedChildrenChanges appended(LinkedHashMap<String, Name> appended) {
            if (appended != null) {
                this.appended = appended;
            }
            return this;
        }

        private FederatedChildrenChanges renamed(Map<String, Name> renamed) {
            if (renamed != null) {
                this.renamed = renamed;
            }
            return this;
        }

        private FederatedChildrenChanges insertedBeforeAnotherChild(Map<String, LinkedHashMap<String, Name>> insertedBeforeAnotherChild) {
            if (insertedBeforeAnotherChild != null) {
                this.insertedBeforeAnotherChild = insertedBeforeAnotherChild;
            }
            return this;
        }

        private FederatedChildrenChanges removed(Set<String> removed) {
            if (removed != null) {
                this.removed = removed;
            }
            return this;
        }
    }

    protected class FederatedMixinChanges
    implements DocumentChanges.MixinChanges {
        private Set<Name> added = Collections.emptySet();
        private Set<Name> removed = Collections.emptySet();

        private FederatedMixinChanges() {
        }

        @Override
        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }

        @Override
        public Set<Name> getAdded() {
            return this.added;
        }

        @Override
        public Set<Name> getRemoved() {
            return this.removed;
        }

        private FederatedMixinChanges added(Set<Name> added) {
            if (added != null) {
                this.added = added;
            }
            return this;
        }

        private DocumentChanges.MixinChanges removed(Set<Name> removed) {
            if (removed != null) {
                this.removed = removed;
            }
            return this;
        }
    }

    protected class FederatedPropertyChanges
    implements DocumentChanges.PropertyChanges {
        private Set<Name> added = Collections.emptySet();
        private Set<Name> changed = Collections.emptySet();
        private Set<Name> removed = Collections.emptySet();

        private FederatedPropertyChanges() {
        }

        @Override
        public boolean isEmpty() {
            return this.changed.isEmpty() && this.removed.isEmpty();
        }

        @Override
        public Set<Name> getChanged() {
            return this.changed;
        }

        @Override
        public Set<Name> getRemoved() {
            return this.removed;
        }

        @Override
        public Set<Name> getAdded() {
            return this.added;
        }

        private FederatedPropertyChanges changed(Set<Name> changed) {
            if (changed != null) {
                this.changed = changed;
            }
            return this;
        }

        private FederatedPropertyChanges removed(Set<Name> removed) {
            if (removed != null) {
                this.removed = removed;
            }
            return this;
        }

        private DocumentChanges.PropertyChanges added(Set<Name> added) {
            this.added = added;
            return this;
        }
    }
}

