/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.jcr.query.qom.Constraint;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalIndex;
import org.modeshape.jcr.index.local.Operations;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;

final class LocalEnumeratedIndex
implements LocalIndex<String> {
    private static final Logger LOGGER = Logger.getLogger(LocalEnumeratedIndex.class);
    private final String name;
    private final String workspace;
    protected final ConcurrentNavigableMap<String, Set<String>> nodeKeySetsByValue;
    private final IndexValues.Converter<String> converter;
    private final DB db;
    private final Set<String> possibleValues;
    private final String workspaceName;
    private final boolean isNew;

    static LocalEnumeratedIndex create(String name, String workspaceName, DB db, IndexValues.Converter<String> converter, BTreeKeySerializer<String> valueSerializer, Set<String> enumeratedValues) {
        return new LocalEnumeratedIndex(name, workspaceName, db, converter, valueSerializer, enumeratedValues);
    }

    static LocalEnumeratedIndex create(String name, String workspaceName, DB db, IndexValues.Converter<String> converter, BTreeKeySerializer<String> valueSerializer) {
        return new LocalEnumeratedIndex(name, workspaceName, db, converter, valueSerializer, null);
    }

    LocalEnumeratedIndex(String name, String workspaceName, DB db, IndexValues.Converter<String> converter, BTreeKeySerializer<String> valueSerializer, Set<String> possibleValues) {
        this.name = name;
        this.workspace = workspaceName;
        this.converter = converter;
        this.db = db;
        this.workspaceName = workspaceName;
        this.possibleValues = possibleValues != null ? new HashSet<String>(possibleValues) : new HashSet();
        this.nodeKeySetsByValue = new ConcurrentSkipListMap<String, Set<String>>();
        boolean foundContent = false;
        for (String collectionName : db.getAll().keySet()) {
            foundContent = true;
            String prefix = this.name + "/enumerated/";
            if (!collectionName.startsWith(prefix) || collectionName.length() <= prefix.length()) continue;
            String valueString = collectionName.substring(prefix.length());
            Set<String> keysForValue = this.createOrGetKeySet(valueString);
            this.nodeKeySetsByValue.put(valueString, keysForValue);
        }
        for (String possibleValue : this.possibleValues) {
            if (this.nodeKeySetsByValue.containsKey(possibleValue)) continue;
            Set<String> keysForValue = this.createOrGetKeySet(possibleValue);
            this.nodeKeySetsByValue.put(possibleValue, keysForValue);
        }
        this.isNew = !foundContent;
    }

    private Set<String> createOrGetKeySet(String value) {
        String collectionName = this.collectionName(value);
        Set<String> keySet = null;
        if (this.db.exists(collectionName)) {
            LOGGER.debug("Reopening enum storage '{0}' for '{1}' index in workspace '{2}'", new Object[]{collectionName, this.name, this.workspaceName});
            keySet = this.db.getHashSet(collectionName);
        } else {
            LOGGER.debug("Creating enum storage '{0}' for '{1}' index in workspace '{2}'", new Object[]{collectionName, this.name, this.workspaceName});
            keySet = this.db.createHashSet(collectionName).make();
        }
        Set<String> previous = this.nodeKeySetsByValue.putIfAbsent(value, keySet);
        if (previous != null) {
            keySet = previous;
        }
        return keySet;
    }

    private String collectionName(String value) {
        return this.name + "/enumerated/" + value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getWorkspaceName() {
        return this.workspace;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    protected final IndexValues.Converter<String> converter() {
        return this.converter;
    }

    @Override
    public long estimateTotalCount() {
        long count = 0L;
        for (Map.Entry entry : this.nodeKeySetsByValue.entrySet()) {
            count += (long)((Set)entry.getValue()).size();
        }
        return count;
    }

    @Override
    public Filter.Results filter(IndexConstraints filter) {
        return Operations.createEnumeratedFilter(this.nodeKeySetsByValue, this.converter, filter.getConstraints(), filter.getVariables()).getResults();
    }

    @Override
    public long estimateCardinality(Constraint constraint, Map<String, Object> variables) {
        return Operations.createEnumeratedFilter(this.nodeKeySetsByValue, this.converter, Collections.singleton(constraint), variables).estimateCount();
    }

    @Override
    public void add(String nodeKey, String value) {
        Set<String> keySet = (Set<String>)this.nodeKeySetsByValue.get(value);
        if (keySet == null) {
            keySet = this.createOrGetKeySet(value);
        }
        keySet.add(nodeKey);
    }

    @Override
    public void remove(String nodeKey) {
        for (Set nodeKeySet : this.nodeKeySetsByValue.values()) {
            nodeKeySet.remove(nodeKey);
        }
    }

    @Override
    public void remove(String nodeKey, String value) {
        Set nodeKeySet = (Set)this.nodeKeySetsByValue.get(value);
        if (nodeKeySet != null) {
            nodeKeySet.remove(nodeKey);
        }
    }

    @Override
    public synchronized void removeAll() {
        for (Map.Entry entry : this.nodeKeySetsByValue.entrySet()) {
            ((Set)entry.getValue()).clear();
            String collectionName = this.collectionName((String)entry.getKey());
            if (!this.db.exists(collectionName)) continue;
            this.db.delete(collectionName);
        }
        this.nodeKeySetsByValue.clear();
    }

    @Override
    public void commit() {
        this.db.commit();
    }

    @Override
    public synchronized void shutdown(boolean destroyed) {
        if (destroyed) {
            for (String value : this.nodeKeySetsByValue.keySet()) {
                String collectionName = this.collectionName(value);
                if (!this.db.exists(collectionName)) continue;
                this.db.delete(collectionName);
            }
            this.nodeKeySetsByValue.clear();
        }
    }
}

