/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Comparator;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.local.IndexChangeAdapters;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalDuplicateIndex;
import org.modeshape.jcr.index.local.LocalEnumeratedIndex;
import org.modeshape.jcr.index.local.LocalIndexException;
import org.modeshape.jcr.index.local.LocalUniqueIndex;
import org.modeshape.jcr.index.local.ManagedLocalIndex;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactory;

public abstract class ManagedLocalIndexBuilder<T> {
    protected final ExecutionContext context;
    protected final MapDB.Serializers serializers;
    protected final NodeTypes.Supplier nodeTypesSupplier;
    protected final IndexDefinition defn;
    protected final ChangeSetAdapter.NodeTypePredicate matcher;

    public static <T> ManagedLocalIndexBuilder<T> create(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        if (defn.hasSingleColumn()) {
            PropertyType actualPropertyType = ManagedLocalIndexBuilder.determineActualPropertyType(defn.getColumnDefinition(0));
            return new SingleColumnIndexBuilder(context, defn, nodeTypesSupplier, matcher, actualPropertyType);
        }
        throw new LocalIndexException("The local provider does not support multi-column indexes");
    }

    protected static PropertyType determineActualPropertyType(IndexColumnDefinition columnDefn) {
        PropertyType type = PropertyType.valueFor(columnDefn.getColumnType());
        switch (type) {
            case BOOLEAN: 
            case DATE: 
            case DECIMAL: 
            case DOUBLE: 
            case LONG: 
            case STRING: 
            case NAME: 
            case PATH: {
                return type;
            }
            case BINARY: 
            case OBJECT: 
            case REFERENCE: 
            case SIMPLEREFERENCE: 
            case WEAKREFERENCE: 
            case URI: {
                return PropertyType.STRING;
            }
        }
        assert (false) : "should never get here";
        return type;
    }

    protected ManagedLocalIndexBuilder(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        this.context = context;
        this.serializers = MapDB.serializers(this.context.getValueFactories());
        this.nodeTypesSupplier = nodeTypesSupplier;
        this.defn = defn;
        this.matcher = matcher;
    }

    public abstract ManagedLocalIndex build(String var1, DB var2) throws LocalIndexException;

    public abstract void validate(Problems var1);

    protected final NodeTypes.Supplier getNodeTypesSupplier() {
        return this.nodeTypesSupplier;
    }

    protected final String indexName() {
        return this.defn.getName();
    }

    protected abstract Serializer<T> getSerializer();

    protected abstract BTreeKeySerializer<T> getBTreeKeySerializer();

    protected abstract Comparator<T> getComparator();

    protected abstract IndexValues.Converter<T> getConverter();

    protected abstract Class<T> getValueClass();

    protected boolean isNodeTypesIndex() {
        return false;
    }

    protected boolean isPrimaryTypeIndex() {
        return false;
    }

    protected boolean isMixinTypesIndex() {
        return false;
    }

    protected boolean isNodeNameIndex() {
        return false;
    }

    protected boolean isNodeLocalNameIndex() {
        return false;
    }

    protected boolean isNodeDepthIndex() {
        return false;
    }

    protected boolean isNodePathIndex() {
        return false;
    }

    protected boolean hasSingleColumn() {
        return this.defn.hasSingleColumn();
    }

    protected IndexColumnDefinition firstColumn() {
        return this.defn.getColumnDefinition(0);
    }

    protected final Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected final boolean matches(IndexColumnDefinition defn, Name name) {
        return defn.getPropertyName().equals(name.getString(this.context.getNamespaceRegistry()));
    }

    protected final boolean matches(String actual, Name name) {
        return actual.equals(name.getString(this.context.getNamespaceRegistry()));
    }

    protected final boolean isType(PropertyType propType, PropertyType expected) {
        return propType == expected;
    }

    protected final boolean isType(PropertyType propType, PropertyType expected1, PropertyType expected2) {
        return propType == expected1 || propType == expected2;
    }

    protected static class SingleColumnIndexBuilder<T>
    extends ManagedLocalIndexBuilder<T> {
        private final IndexColumnDefinition columnDefn;
        private final PropertyType type;
        private final Serializer<T> serializer;
        private final BTreeKeySerializer<T> btreeSerializer;
        private final Comparator<T> comparator;
        private final BTreeKeySerializer<String> stringBtreeSerializer;
        private final Comparator<String> stringComparator;
        private final Class<T> clazz;
        private final IndexValues.Converter<T> converter;
        private final IndexValues.Converter<String> stringConverter;
        private final ValueFactory<T> factory;
        private final ValueFactory<String> stringFactory;

        protected SingleColumnIndexBuilder(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher, PropertyType actualPropertyType) {
            super(context, defn, nodeTypesSupplier, matcher);
            assert (defn.hasSingleColumn());
            this.columnDefn = defn.getColumnDefinition(0);
            this.type = actualPropertyType;
            this.clazz = this.type.getValueClass();
            this.serializer = this.serializers.serializerFor(this.clazz);
            this.comparator = this.type.getComparator();
            this.btreeSerializer = this.serializers.bTreeKeySerializerFor(this.clazz, this.comparator, false);
            this.factory = this.context.getValueFactories().getValueFactory(this.type);
            this.converter = IndexValues.converter(this.factory);
            this.stringComparator = ValueComparators.STRING_COMPARATOR;
            this.stringFactory = this.context.getValueFactories().getStringFactory();
            this.stringBtreeSerializer = this.serializers.bTreeKeySerializerFor(String.class, this.stringComparator, false);
            this.stringConverter = IndexValues.converter(this.stringFactory);
        }

        @Override
        protected Serializer<T> getSerializer() {
            return this.serializer;
        }

        @Override
        protected BTreeKeySerializer<T> getBTreeKeySerializer() {
            return this.btreeSerializer;
        }

        @Override
        protected Comparator<T> getComparator() {
            return this.comparator;
        }

        @Override
        protected Class<T> getValueClass() {
            return this.clazz;
        }

        protected PropertyType getColumnType() {
            return this.type;
        }

        @Override
        protected IndexValues.Converter<T> getConverter() {
            return this.converter;
        }

        @Override
        protected boolean isNodeTypesIndex() {
            return this.defn.getKind() == IndexDefinition.IndexKind.NODE_TYPE;
        }

        @Override
        protected boolean isPrimaryTypeIndex() {
            return this.matches(this.columnDefn, JcrLexicon.PRIMARY_TYPE) && this.isType(this.getColumnType(), PropertyType.NAME);
        }

        @Override
        protected boolean isMixinTypesIndex() {
            return this.matches(this.columnDefn, JcrLexicon.MIXIN_TYPES) && this.isType(this.getColumnType(), PropertyType.NAME);
        }

        @Override
        protected boolean isNodeNameIndex() {
            return this.matches(this.columnDefn, JcrLexicon.NAME) && this.isType(this.getColumnType(), PropertyType.NAME);
        }

        @Override
        protected boolean isNodeLocalNameIndex() {
            return this.matches(this.columnDefn, ModeShapeLexicon.LOCALNAME) && this.isType(this.getColumnType(), PropertyType.STRING);
        }

        @Override
        protected boolean isNodeDepthIndex() {
            return this.matches(this.columnDefn, ModeShapeLexicon.DEPTH) && this.isType(this.getColumnType(), PropertyType.LONG);
        }

        @Override
        protected boolean isNodePathIndex() {
            return this.matches(this.columnDefn, JcrLexicon.PATH) && this.isType(this.getColumnType(), PropertyType.PATH);
        }

        @Override
        public void validate(Problems problems) {
            switch (this.defn.getKind()) {
                case VALUE: {
                    if (this.matches(this.columnDefn, JcrLexicon.PATH) && !this.isType(this.getColumnType(), PropertyType.PATH)) {
                        problems.addError(JcrI18n.localIndexMustHaveOneColumnOfSpecificType, new Object[]{this.defn.getProviderName(), this.defn.getName(), this.columnDefn.getPropertyName(), this.type, PropertyType.PATH});
                    }
                    if (this.matches(this.columnDefn, ModeShapeLexicon.LOCALNAME) && !this.isType(this.getColumnType(), PropertyType.STRING) || this.matches(this.columnDefn, ModeShapeLexicon.ID) && !this.isType(this.getColumnType(), PropertyType.STRING)) {
                        problems.addError(JcrI18n.localIndexMustHaveOneColumnOfSpecificType, new Object[]{this.defn.getProviderName(), this.defn.getName(), this.columnDefn.getPropertyName(), this.type, PropertyType.STRING});
                    }
                    if (this.matches(this.columnDefn, ModeShapeLexicon.DEPTH) && !this.isType(this.getColumnType(), PropertyType.LONG)) {
                        problems.addError(JcrI18n.localIndexMustHaveOneColumnOfSpecificType, new Object[]{this.defn.getProviderName(), this.defn.getName(), this.columnDefn.getPropertyName(), this.type, PropertyType.LONG});
                    }
                    if (!(this.matches(this.columnDefn, JcrLexicon.PRIMARY_TYPE) && !this.isType(this.getColumnType(), PropertyType.NAME) || this.matches(this.columnDefn, JcrLexicon.MIXIN_TYPES) && !this.isType(this.getColumnType(), PropertyType.NAME)) && (!this.matches(this.columnDefn, JcrLexicon.NAME) || this.isType(this.getColumnType(), PropertyType.NAME))) break;
                    problems.addError(JcrI18n.localIndexMustHaveOneColumnOfSpecificType, new Object[]{this.defn.getProviderName(), this.defn.getName(), this.columnDefn.getPropertyName(), this.type, PropertyType.NAME});
                    break;
                }
                case UNIQUE_VALUE: {
                    break;
                }
                case ENUMERATED_VALUE: {
                    break;
                }
                case NODE_TYPE: {
                    if (this.columnDefn.getColumnType() == PropertyType.STRING.jcrType()) break;
                    problems.addError(JcrI18n.localIndexMustHaveOneColumnOfSpecificType, new Object[]{this.defn.getProviderName(), this.defn.getName(), this.columnDefn.getPropertyName(), this.type, PropertyType.STRING});
                    break;
                }
                case TEXT: {
                    problems.addError(JcrI18n.localIndexProviderDoesNotSupportTextIndexes, new Object[]{this.defn.getProviderName(), this.defn.getName()});
                }
            }
        }

        @Override
        public ManagedLocalIndex build(String workspaceName, DB db) throws LocalIndexException {
            IndexChangeAdapter changeAdapter = null;
            switch (this.defn.getKind()) {
                case VALUE: {
                    assert (!this.isNodeTypesIndex());
                    LocalDuplicateIndex<Name> dupIndex = LocalDuplicateIndex.create(this.indexName(), workspaceName, db, this.getConverter(), this.getSerializer(), this.getComparator());
                    if (this.isPrimaryTypeIndex()) {
                        LocalDuplicateIndex<Name> strIndex = dupIndex;
                        changeAdapter = IndexChangeAdapters.forPrimaryType(this.context, this.matcher, workspaceName, strIndex);
                    } else if (this.isMixinTypesIndex()) {
                        LocalDuplicateIndex<Name> strIndex = dupIndex;
                        changeAdapter = IndexChangeAdapters.forMixinTypes(this.context, this.matcher, workspaceName, strIndex);
                    } else if (this.isNodeNameIndex()) {
                        LocalDuplicateIndex<Name> strIndex = dupIndex;
                        changeAdapter = IndexChangeAdapters.forNodeName(this.context, this.matcher, workspaceName, strIndex);
                    } else if (this.isNodeLocalNameIndex()) {
                        LocalDuplicateIndex<Name> strIndex = dupIndex;
                        changeAdapter = IndexChangeAdapters.forNodeLocalName(this.context, this.matcher, workspaceName, strIndex);
                    } else if (this.isNodePathIndex()) {
                        LocalDuplicateIndex<Name> strIndex = dupIndex;
                        changeAdapter = IndexChangeAdapters.forNodePath(this.context, this.matcher, workspaceName, strIndex);
                    } else if (this.isNodeDepthIndex()) {
                        LocalDuplicateIndex<Name> strIndex = dupIndex;
                        changeAdapter = IndexChangeAdapters.forNodeDepth(this.context, this.matcher, workspaceName, strIndex);
                    } else {
                        Name propertyName = this.name(this.firstColumn().getPropertyName());
                        assert (propertyName != null);
                        changeAdapter = IndexChangeAdapters.forSingleValuedProperty(this.context, this.matcher, workspaceName, propertyName, this.factory, dupIndex);
                    }
                    return new ManagedLocalIndex(dupIndex, changeAdapter);
                }
                case UNIQUE_VALUE: {
                    assert (!this.isNodeTypesIndex());
                    assert (!this.isPrimaryTypeIndex());
                    assert (!this.isMixinTypesIndex());
                    LocalUniqueIndex<T> uidx = LocalUniqueIndex.create(this.indexName(), workspaceName, db, this.getConverter(), this.getBTreeKeySerializer(), this.getSerializer());
                    Name propertyName = this.name(this.firstColumn().getPropertyName());
                    assert (propertyName != null);
                    changeAdapter = IndexChangeAdapters.forUniqueValuedProperty(this.context, this.matcher, workspaceName, propertyName, this.factory, uidx);
                    return new ManagedLocalIndex(uidx, changeAdapter);
                }
                case ENUMERATED_VALUE: {
                    assert (!this.isNodeTypesIndex());
                    assert (!this.isPrimaryTypeIndex());
                    assert (!this.isMixinTypesIndex());
                    Name propertyName = this.name(this.firstColumn().getPropertyName());
                    assert (propertyName != null);
                    LocalEnumeratedIndex idx = LocalEnumeratedIndex.create(this.defn.getName(), workspaceName, db, this.stringConverter, this.stringBtreeSerializer);
                    changeAdapter = IndexChangeAdapters.forSingleValuedEnumeratedProperty(this.context, this.matcher, workspaceName, propertyName, idx);
                    return new ManagedLocalIndex(idx, changeAdapter);
                }
                case NODE_TYPE: {
                    LocalEnumeratedIndex idx = LocalEnumeratedIndex.create(this.defn.getName(), workspaceName, db, this.stringConverter, this.stringBtreeSerializer);
                    changeAdapter = IndexChangeAdapters.forNodeTypes(this.context, this.matcher, workspaceName, idx);
                    return new ManagedLocalIndex(idx, changeAdapter);
                }
                case TEXT: {
                    assert (false) : "should not ever see this because validation should prevent such indexes from being used";
                    break;
                }
            }
            assert (false) : "Should never get here";
            throw new IllegalArgumentException("Unexpected index kind on: " + this.defn);
        }
    }
}

