/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.text.StringCharacterIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Visitors;

public class QueryUtil {
    protected static boolean hasWildcardCharacters(String expression) {
        StringCharacterIterator iter = new StringCharacterIterator(expression);
        boolean skipNext = false;
        char c = iter.first();
        while (c != '\uffff') {
            if (skipNext) {
                skipNext = false;
            } else {
                if (c == '*' || c == '?' || c == '%' || c == '_') {
                    return true;
                }
                if (c == '\\') {
                    skipNext = true;
                }
            }
            c = iter.next();
        }
        return false;
    }

    protected static String toWildcardExpression(String likeExpression) {
        return likeExpression.replace('%', '*').replace('_', '?').replaceAll("\\\\(.)", "$1");
    }

    public static String toRegularExpression(String likeExpression) {
        String result = likeExpression.replaceAll("\\\\(.)", "$1");
        result = result.replaceAll("([$.|+()\\[\\\\^\\\\\\\\])", "\\\\$1");
        result = result.replace("*", ".*").replace("?", ".");
        result = result.replace("%", ".*").replace("_", ".");
        result = result.replace("\\[.*]", "\\[\\d+]");
        return result;
    }

    public static boolean includeFullTextScores(Iterable<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            if (!QueryUtil.includeFullTextScores(constraint)) continue;
            return true;
        }
        return false;
    }

    public static boolean includeFullTextScores(Constraint constraint) {
        final AtomicBoolean includeFullTextScores = new AtomicBoolean(false);
        if (constraint != null) {
            Visitors.visitAll(constraint, new Visitors.AbstractVisitor(){

                @Override
                public void visit(FullTextSearch obj) {
                    includeFullTextScores.set(true);
                }
            });
        }
        return includeFullTextScores.get();
    }

    private QueryUtil() {
    }

    public static String addSnsIndexesToLikeExpression(String pathLikeExpression) {
        if ("%".equals(pathLikeExpression)) {
            return pathLikeExpression;
        }
        boolean altered = false;
        StringBuilder sb = new StringBuilder();
        for (String segment : pathLikeExpression.split("/")) {
            if (segment.length() == 0) continue;
            sb.append('/').append(segment);
            if (segment.endsWith("%") || segment.endsWith("]")) continue;
            sb.append("[1]");
            altered = true;
        }
        return altered ? sb.toString() : pathLikeExpression;
    }
}

