/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security.acl;

import java.util.ArrayList;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import org.modeshape.common.annotation.Immutable;

@Immutable
public class PrivilegeImpl
implements Privilege {
    private static final String URI = "http://www.jcp.org/jcr/1.0";
    private String name;
    private Privilege[] declaredPrivileges;
    private boolean isAbstract = false;
    private Session session;

    public PrivilegeImpl(Session session, String name, Privilege[] declaredPrivileges) {
        this.name = name.substring(name.indexOf(125) + 1);
        this.declaredPrivileges = declaredPrivileges;
        this.session = session;
    }

    public PrivilegeImpl(Session session, String name, Privilege[] declaredPrivileges, boolean isAbstract) {
        this.session = session;
        this.name = name.substring(name.indexOf(125) + 1);
        this.declaredPrivileges = declaredPrivileges;
        this.isAbstract = isAbstract;
    }

    public String localName() {
        return this.name;
    }

    public String getName() {
        try {
            return this.session.getNamespacePrefix(URI) + ":" + this.name;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isAggregate() {
        return this.declaredPrivileges != null && this.declaredPrivileges.length > 0;
    }

    public Privilege[] getDeclaredAggregatePrivileges() {
        return this.declaredPrivileges;
    }

    public Privilege[] getAggregatePrivileges() {
        ArrayList<Privilege> list = new ArrayList<Privilege>();
        for (Privilege ap : this.getDeclaredAggregatePrivileges()) {
            this.aggregate(list, ap);
        }
        Privilege[] res = new Privilege[list.size()];
        list.toArray(res);
        return res;
    }

    private void aggregate(ArrayList<Privilege> list, Privilege p) {
        list.add(p);
        if (p.isAggregate()) {
            for (Privilege ap : p.getDeclaredAggregatePrivileges()) {
                this.aggregate(list, ap);
            }
        }
    }

    public boolean contains(Privilege p) {
        Privilege[] list;
        if (p.getName().equalsIgnoreCase(this.getName())) {
            return true;
        }
        for (Privilege privilege : list = this.getAggregatePrivileges()) {
            if (!privilege.getName().equalsIgnoreCase(p.getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Privilege)) {
            return false;
        }
        return ((Privilege)other).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

