/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.ReadOnlyIterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.basic.BasicProperty;
import org.modeshape.jcr.value.basic.NodeKeyReference;

@Immutable
public class BasicMultiValueProperty
extends BasicProperty {
    private static final long serialVersionUID = 1L;
    private final List<Object> values;

    public BasicMultiValueProperty(Name name, List<Object> values) {
        super(name);
        CheckArg.isNotNull(values, (String)"values");
        this.values = values;
    }

    public BasicMultiValueProperty(Name name, Object ... values) {
        super(name);
        CheckArg.isNotNull((Object)values, (String)"values");
        CheckArg.hasSizeOfAtLeast((Object[])values, (int)2, (String)"values");
        this.values = Arrays.asList(values);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isMultiple() {
        return true;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean isReference() {
        Object firstValue = this.getFirstValue();
        if (firstValue instanceof NodeKeyReference) {
            return !((NodeKeyReference)firstValue).isSimple();
        }
        return firstValue instanceof Reference;
    }

    @Override
    public boolean isSimpleReference() {
        Object firstValue = this.getFirstValue();
        return firstValue instanceof Reference && ((Reference)firstValue).isSimple();
    }

    @Override
    public boolean isBinary() {
        return this.getFirstValue() instanceof Binary;
    }

    @Override
    public int size() {
        return this.values != null ? this.values.size() : 0;
    }

    @Override
    public Object getFirstValue() {
        return this.size() == 0 ? null : this.values.get(0);
    }

    @Override
    public Iterator<Object> iterator() {
        return ReadOnlyIterator.around(this.values.iterator());
    }

    @Override
    public Object getValue(int index) throws IndexOutOfBoundsException {
        return this.values.get(index);
    }
}

