/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaTypeRequestMatcher
implements RequestMatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ContentNegotiationStrategy contentNegotiationStrategy;
    private final Collection<MediaType> matchingMediaTypes;
    private boolean useEquals;
    private Set<MediaType> ignoredMediaTypes = Collections.emptySet();

    public MediaTypeRequestMatcher(ContentNegotiationStrategy contentNegotiationStrategy, MediaType ... matchingMediaTypes) {
        this(contentNegotiationStrategy, Arrays.asList(matchingMediaTypes));
    }

    public MediaTypeRequestMatcher(ContentNegotiationStrategy contentNegotiationStrategy, Collection<MediaType> matchingMediaTypes) {
        Assert.notNull((Object)contentNegotiationStrategy, (String)"ContentNegotiationStrategy cannot be null");
        Assert.notEmpty(matchingMediaTypes, (String)"matchingMediaTypes cannot be null or empty");
        this.contentNegotiationStrategy = contentNegotiationStrategy;
        this.matchingMediaTypes = matchingMediaTypes;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        List httpRequestMediaTypes;
        try {
            httpRequestMediaTypes = this.contentNegotiationStrategy.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        }
        catch (HttpMediaTypeNotAcceptableException e) {
            this.logger.debug((Object)"Failed to parse MediaTypes, returning false", (Throwable)e);
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("httpRequestMediaTypes=" + httpRequestMediaTypes));
        }
        for (MediaType httpRequestMediaType : httpRequestMediaTypes) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing " + httpRequestMediaType));
            }
            if (this.shouldIgnore(httpRequestMediaType)) {
                this.logger.debug((Object)"Ignoring");
                continue;
            }
            if (this.useEquals) {
                boolean isEqualTo = this.matchingMediaTypes.contains(httpRequestMediaType);
                this.logger.debug((Object)("isEqualTo " + isEqualTo));
                return isEqualTo;
            }
            for (MediaType matchingMediaType : this.matchingMediaTypes) {
                boolean isCompatibleWith = matchingMediaType.isCompatibleWith(httpRequestMediaType);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(matchingMediaType + " .isCompatibleWith " + httpRequestMediaType + " = " + isCompatibleWith));
                }
                if (!isCompatibleWith) continue;
                return true;
            }
        }
        this.logger.debug((Object)"Did not match any media types");
        return false;
    }

    private boolean shouldIgnore(MediaType httpRequestMediaType) {
        for (MediaType ignoredMediaType : this.ignoredMediaTypes) {
            if (!httpRequestMediaType.includes(ignoredMediaType)) continue;
            return true;
        }
        return false;
    }

    public void setUseEquals(boolean useEquals) {
        this.useEquals = useEquals;
    }

    public void setIgnoredMediaTypes(Set<MediaType> ignoredMediaTypes) {
        this.ignoredMediaTypes = ignoredMediaTypes;
    }

    public String toString() {
        return "MediaTypeRequestMatcher [contentNegotiationStrategy=" + this.contentNegotiationStrategy + ", matchingMediaTypes=" + this.matchingMediaTypes + ", useEquals=" + this.useEquals + ", ignoredMediaTypes=" + this.ignoredMediaTypes + "]";
    }
}

