/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.deployit.upgrade.UpgradeRejectedException;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Upgrader
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(Upgrader.class);
    private final Set<String> components = Sets.newLinkedHashSet();
    private final ListMultimap<String, Upgrade> upgrades = ArrayListMultimap.create();
    private final boolean forceUpgrades;
    private ApplicationContext applicationContext;
    private JcrTemplate jcrTemplate;
    private boolean questionAsked = false;
    private RepositoryVersionService repositoryVersionService;

    public Upgrader(JcrTemplate jcrTemplate, boolean forceUpgrades, RepositoryVersionService repositoryVersionService) {
        this.jcrTemplate = jcrTemplate;
        this.forceUpgrades = forceUpgrades;
        this.repositoryVersionService = repositoryVersionService;
    }

    public void addComponent(String component) {
        this.components.add(component);
    }

    @VisibleForTesting
    public void addUpgrade(Upgrade upgrade) {
        String component = upgrade.upgradeVersion().getComponent();
        this.addComponent(component);
        this.upgrades.put((Object)component, (Object)upgrade);
    }

    public void applyUpgrades() {
        for (String component : this.components) {
            this.upgradeComponent(component);
        }
    }

    public void autoUpgrade() {
        this.components.addAll(PluginVersions.getRegisteredPlugins());
        this.upgrades.putAll(this.findUpgrades());
        this.applyUpgrades();
    }

    void upgradeComponent(String component) {
        Version componentVersion;
        logger.debug("Checking component [{}] for upgrades", (Object)component);
        try {
            componentVersion = this.repositoryVersionService.readVersionOfComponent(component);
        }
        catch (RuntimeException e) {
            logger.warn(String.format("Component [%s] has an invalid version -- skipping upgrade", component), (Throwable)e);
            return;
        }
        if (componentVersion == null) {
            logger.debug("Skipping upgrade of component {} as it is not registered", (Object)component);
            return;
        }
        logger.debug("Component [{}] has version [{}] in the repository", (Object)component, (Object)componentVersion);
        List<Upgrade> componentUpgrades = UpgraderHelper.filterApplicable(this.upgrades.get((Object)component), componentVersion);
        if (componentVersion.isVersion0()) {
            Version versionOfComponent = UpgraderHelper.findRecentVersion(componentUpgrades, component);
            if (versionOfComponent == null && PluginVersions.getVersionFor((String)component) != null) {
                versionOfComponent = Version.valueOf((String)component, (String)PluginVersions.getVersionFor((String)component));
            }
            this.repositoryVersionService.storeVersionOfComponent(versionOfComponent);
            logger.debug("Setting version [{}] for component [{}]", (Object)versionOfComponent, (Object)component);
            return;
        }
        if (!componentUpgrades.isEmpty()) {
            logger.info("Checked component [{}] which is at version [{}] -> Found upgrades to run: {}", new Object[]{component, componentVersion, componentUpgrades});
            this.askForUpgrade();
            this.applyUpgrades(componentUpgrades);
        }
    }

    private void askForUpgrade() {
        if (!this.questionAsked && !this.forceUpgrades) {
            logger.warn("Ensure that you're running in 'interactive' mode and look at your console to continue the upgrade process.");
            String NL = System.lineSeparator();
            logger.info("Upgraders need to be run, asking user to confirm.");
            String msg = NL + "*** WARNING ***" + NL + "We detected that we need to upgrade your repository" + NL + "Before continuing we suggest you backup your repository in case the upgrade fails." + NL + "Please ensure you have 'INFO' level logging configured." + NL + "Please enter 'yes' if you want to continue [no]: ";
            System.out.print(msg);
            String response = this.read();
            if (!"yes".equalsIgnoreCase(response)) {
                logger.error("Did not receive an affirmative response on running upgrades, shutting down.");
                EventBusHolder.publish((Object)new ShutdownEvent());
                throw new UpgradeRejectedException("Did not receive an affirmative response on running upgrades, shutting down.");
            }
            logger.info("User response was: {}", (Object)response);
            this.questionAsked = true;
        }
    }

    private void applyUpgrades(List<Upgrade> applicableUpgrades) {
        final ImmutableListMultimap versionToUpgradeMap = Multimaps.index(applicableUpgrades, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade input) {
                return input.upgradeVersion();
            }
        });
        TreeSet versions = Sets.newTreeSet((Iterable)Lists.transform(applicableUpgrades, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade input) {
                return input.upgradeVersion();
            }
        }));
        for (final Version version : versions) {
            logger.info("Upgrading to version [{}]", (Object)version);
            this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

                public Object doInJcr(Session session) throws RepositoryException {
                    for (Upgrade applicableUpgrade : versionToUpgradeMap.get((Object)version)) {
                        if (applicableUpgrade.doUpgrade((RawRepository)new RawRepositoryImpl(session))) continue;
                        throw new UpgradeException("Could not perform upgrade %s to upgrade to %s", new Object[]{applicableUpgrade.getClass(), applicableUpgrade.upgradeVersion()});
                    }
                    session.save();
                    return null;
                }
            });
            this.repositoryVersionService.storeVersionOfComponent(version);
        }
    }

    protected ListMultimap<String, Upgrade> findUpgrades() {
        Set<Upgrade> allUpgrades = UpgraderHelper.findAndInstantiateSubTypesOf(Upgrade.class, this.applicationContext);
        logger.debug("Found the following upgrades: [{}]", allUpgrades);
        return Multimaps.index(allUpgrades, (Function)new Function<Upgrade, String>(){

            public String apply(Upgrade input) {
                return input.upgradeVersion().getComponent();
            }
        });
    }

    protected String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdin.readLine();
            if (line != null) {
                return line.trim();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

