import json
from parser.xunit import throw_if_some_failed, parse_last_modified, parse_junit_test_results, open_file


def cuke_validate_files(files):
    filtered = []
    for file in files:
        if str(file).endswith("json"):
            filtered.append(file)
    throw_if_some_failed(files, filtered)


def cuke_iterate_test_cases(file):
    """
    Iterate all test cases found in `file`.
    :param file:
    :return: a list/iterator of tuples (test case node, test hierarchy path)
    """
    with open_file(file) as data_file:
        features = json.load(data_file)
        for feature in features:
            for element in feature.get("elements", []):
                if element["type"] == 'scenario':
                    yield (element, (feature['name'], element['name'], str(element['line'])))


def cuke_duration(splitResult):
    steps = splitResult["steps"]
    duration = 0
    for step in steps:
        duration = duration + long(step["result"].get("duration", 0))

    return int(duration / 1000000)


def cuke_result(scenario):
    steps = scenario["steps"]
    for step in steps:
        status = step["result"]["status"]

        if status == "passed":
            continue
        elif status == "failed":
            return "FAILED"
        else:
            return "OTHER"

    return "PASSED"


def cuke_failure_reason(scenario):
    steps = scenario["steps"]
    for step in steps:
        status = step["result"]["status"]

        if status != "passed":
            error_message = step["result"].get("error_message", "")
            unicode_error_message = unicode(error_message, "utf-8")
            return unicode_error_message.encode("ascii", "xmlcharrefreplace")

    return None


def cuke_custom_properties(scenario, file):
    return {
        "scenarioId": scenario["id"]
    }


def cuke_last_modified(file):
    return file.lastModified()


cuke_validate_files(files)

last_modified = parse_last_modified(files, extract_last_modified=cuke_last_modified)

print 'LAST MOD', last_modified, test_run_historian.isKnownKey(str(last_modified))
if not test_run_historian.isKnownKey(str(last_modified)):
    events = parse_junit_test_results(files, last_modified,
                                      iterate_test_cases=cuke_iterate_test_cases,
                                      extract_duration=cuke_duration,
                                      extract_result=cuke_result,
                                      extract_failure_reason=cuke_failure_reason,
                                      extract_custom_properties=cuke_custom_properties)
    print 'built run with events', events
else:
    events = []

# Result holder should contain a list of test runs. A test run is a list of events

result_holder.result = [events] if events else []
