#
# Basic execution of test cases on a host
#
from com.xebialabs.overthere.util import CapturingOverthereExecutionOutputHandler

host = self.host

connection = host.getConnection()

try:
    print "Performing:", str(self.cmdLine), "on host", str(host)
    stdout_handler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    stderr_handler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    working_directory = self.getWorkingDirectory()
    if working_directory:
        connection.setWorkingDirectory(connection.getFile(working_directory))
        print 'Set up the handlers, now executing in working directory %s...' % working_directory
    else:
        print "Set up the handlers, now executing in default working directory..."
    exit_code = connection.execute(stdout_handler, stderr_handler, self.getCmdLine(resolved_command_line))

    print "Command", resolved_command_line, "returned with exit code", exit_code
    for line in stdout_handler.getOutputLines():
        print "output:", line
    for line in stderr_handler.getOutputLines():
        print "error:", line

    print "All done, no exceptions"
finally:
    connection.close()
