<#--
 # NOTE: Please do not edit this file directly
 # Create your custom reports in the 'ext' folder
 #-->

<#macro RESULTTYPE result title>
<h3>${title}</h3>
<table class="table">
<thead>
<tr>
    <th>name</th><th>Last Run</th><th>This Run</th>
</tr>
</thead>
<tbody>
<#assign prefix = query_parameters['prefix']!"">
<#assign depth = prefix?split(";")?size>
<#list test_runs.getResultEventsThatChangedFromLastRun(test_run) as event>
  <#assign hierarchy = event.hierarchy![] >
  <#assign name = hierarchy?join(";") >
  <#if prefix == "">
    <#assign nameMatches = true>
  <#else>
    <#assign nameMatches = name?starts_with(prefix)>
  </#if>
  <#if event.type == 'functionalResult' && event.result == result && nameMatches>
    <tr>
      <td>${hierarchy?join(", ")}</td>
      <td>
      <#if event.result == "PASSED">FAILED<#else>PASSED</#if>
      </td>
      <td>${event.result}</td>
    </tr>
    <tr class="secondary">
      <td colspan="4">
        <#if depth &gt; 3>
          <#assign correspondingOlderEvents = test_runs.getCorrespondingEventsFromOlderRuns(test_run, event, 10, '@type', '@hierarchy')>
          <#assign thisResult = event.result!"">
          <#assign prevResult = thisResult>
          <#assign nChanges = 0>
          <#assign total = 1>
          <#list correspondingOlderEvents as olderEvent>
            <#assign oldResult = olderEvent.result!"">
            <#if oldResult != prevResult>
              <#assign prevResult = oldResult>
              <#assign nChanges = nChanges + 1>
            </#if>
            <#assign total = total + 1>
          </#list>

          <#assign flaky = ((nChanges / total) * 100)?floor >
          <br/>
          <table>
            <tr>
              <td><div title="Flakiness is the number of different test results over time divided by the number of test results">${flaky}% flaky</div></td>
                <#list correspondingOlderEvents as olderEvent>
                  <#assign oldResult = olderEvent.result!"">
                  <#assign report_id = this.getId() >
                  <#assign run_id = olderEvent.testRunId >
                  <#assign runDay = this.thisDay(olderEvent.createdAt) >
                  <#if oldResult == "PASSED">
                    <td bgcolor="#9ada7f">
                  <#else>
                    <td bgcolor="#fd8d10">
                  </#if>
                  <a href="#/reports/${run_id}/${report_id}?prefix=${name}">${runDay}</a>
                </td>
              </#list>
            </tr>
          </table>
        </#if>
      </td>
    </tr>
  </#if>
</#list>
</tbody>
</table>
</#macro>

<#assign events = test_runs.getEventsForTestRun(test_run, queryParams) >
<h2 class="reportTitle">Historical comparison details table</h2>
<p>This report shows a tests that changed state since the previous execution.</p>
<table data-title="Historical comparison details table" class="table two-rows">
<tbody style="overflow-y: auto;">
<@RESULTTYPE result="FAILED" title="Failed"/>
<@RESULTTYPE result="OTHER" title="Other"/>
<@RESULTTYPE result="PASSED" title="Passed"/>
</tbody>
</table>
