# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

import modules.barchart

# Uncomment during development. This will reload the module that is otherwise cached.
# reload(modules.barchart)


def aggregateEvents(test_specification_set):
    """ Aggregate all the events from the test specifications in the test_test_specification_set. """
    test_specifications = test_specification_set.getAllChildren()

    aggregated = []
    for test_specification in test_specifications:
        run = test_runs_repository.getLatestTestRun(test_specification.name, start_date.getTime(), end_date.getTime())
        if run is not None:
            aggregated += test_runs_repository.getEventsForTestRun(run, {'@tags': tags})

    return aggregated

## Main
if __name__ in ['__builtin__', '__main__']:

    events = aggregateEvents(test_specification_set)

    bar_chart = modules.barchart.BarChart(events, query_parameters)
    bar_chart.calculate()

    if bar_chart.at_top_level():
        title = 'Aggregated result counts from the latest test run in the selected time window in the test specification set'
    else:
        title = 'Aggregated result counts from the latest test runs in the test specification set in time window at level %s' % bar_chart.get_level()

    rotation = -45

    result_holder.result = {
        'chart': {
            'type': 'column'
        },
        'title': title,
        'description': 'This report aggregates the functional results of the test specifications in the set. It shows the latest test run in the selected time window. Click the graph to see results on a different level of the test hierarchy.',
        'xAxis': {
            'categories': bar_chart.get_categories(),
            'labels': {
                'rotation': rotation,
            }
        },
        'yAxis': {
            'min': 0,
            'title': {
                'text': 'Number of tests',
                'style': {
                    'color': '#666',
                    'font-weight': 'normal'
                }
            },
            'minTickInterval': 1
        },
        'legend': {
            'borderColor': None,
            'symbolHeight': 16,
            'symbolWidth': 16
        },
        'plotOptions': {
            'column': {
                'animation': False,
                'cursor': 'pointer',
                'borderRadius': 2,
                'groupPadding': 0.1,
                'pointPadding': 0.01
            },
            'series': {
                'point': {
                    'events': {
                        'click': 'url'
                    }
                }
            }
        },
        'series': [{
            'name': "Passed ({0})".format(bar_chart.get_passed_result_count()),
            'data': bar_chart.get_passed_results()
        }, {
            'name': "Failed ({0})".format(bar_chart.get_failed_result_count()),
            'data': bar_chart.get_failed_results()
        }, {
            'name': "Other ({0})".format(bar_chart.get_other_result_count()),
            'data': bar_chart.get_other_results()
        }]
    }
