# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.hierarchy import *

prefixParam = get_prefix_param(query_parameters)
prefixArray = get_prefix_array(query_parameters)

prefix = ''

level = len(prefixArray)

paramDate = query_parameters.get('date')
paramRange = query_parameters.get('range')

# only 1 level deep
testSpecs = test_specification_set.testSpecifications


# qualification statuses, not test case results:
passed = 0
failed = 0

#
for testSpec in testSpecs:
    qualification = qualification_repository.getLatestQualificationResult(testSpec.name)
    if qualification.get("result") == "PASSED":
        passed = passed + 1
    else:
        failed = failed + 1

result_holder.result = {
    'chart': {
        'type': 'pie',
        'plotBackgroundColor': None,
        'plotBorderWidth': None,
        'plotShadow': False
    },
    'title': 'Passed versus failed test specifications from their latest qualification',
    'description': 'This report presents the number of passing and failing qualifications of test specifications of a test specification set.',
    'tooltip': {
        'enabled': False
    },
    'legend': {
        'borderColor': None,
        'layout': 'vertical',
        'verticalAlign': 'middle',
        'symbolHeight': 12,
        'symbolWidth': 12,
        'symbolRadius': 6,
        'itemMarginBottom': 4
    },
    'plotOptions': {
        'series': {
            'slicedOffset': 0,
            'point': {
                'events': {
                    'click': 'url'
                }
            }
        },
        'pie': {
            'allowPointSelect': True,
            'dataLabels': {
                'enabled': True,
                'distance': -15,
                'format': '{y}'
            },
            'innerSize': '70%',
            'showInLegend': 'True',
            'animation': False,
            'states': {
                'hover': {
                    'enabled': False
                }
            }
        }
    },
    'series': [{
        'data': [{
            'name': "Passed ({0})".format(passed),
            'y': passed
        },
            {
                'name': "Failed ({0})".format(failed),
                'y': failed
            }
        ]
    }]
}
