/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.xunit;

import com.google.common.base.Strings;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.NothingToImportException;
import com.xebialabs.xltest.importers.ImporterUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XUnitReportXmlImporter {
    public static final String TESTSUITE_TAG = "testsuite";
    public static final String TESTCASE_TAG = "testcase";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder documentBuilder;
    private final DateTimeFormatter isoDateTimeFormatter = ISODateTimeFormat.dateHourMinuteSecond();
    private final OverthereFile xunitReportXmlFile;
    private final String moduleName;
    private NodeList testSuites;

    public XUnitReportXmlImporter(OverthereFile xunitReportXmlFile) {
        this("", xunitReportXmlFile);
    }

    public XUnitReportXmlImporter(String moduleName, OverthereFile xunitReportXmlFile) {
        this.moduleName = moduleName;
        this.xunitReportXmlFile = xunitReportXmlFile;
        this.documentBuilder = this.newDocumentBuilder();
    }

    private DocumentBuilder newDocumentBuilder() {
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to create an XML document builder", e);
        }
    }

    public long getLastModified() throws ImportFailedException, NothingToImportException {
        long lastModified = 0L;
        this.parseXml();
        for (int i = 0; i < this.testSuites.getLength(); ++i) {
            Element testSuite = (Element)this.testSuites.item(i);
            lastModified = Math.max(lastModified, this.getLastModifiedInMilliseconds(testSuite));
        }
        return lastModified;
    }

    public int doImport(UUID testRunId, EventHandler eventHandler) throws ImportException {
        int duration = 0;
        this.parseXml();
        String sourceFile = this.xunitReportXmlFile.getName();
        for (int i = 0; i < this.testSuites.getLength(); ++i) {
            Element testSuite = (Element)this.testSuites.item(i);
            duration += this.getDurationInMilliseconds(testSuite);
            this.createEventsForTestResults(testSuite, testRunId, eventHandler, sourceFile);
        }
        return duration;
    }

    private void parseXml() throws ImportFailedException, NothingToImportException {
        if (this.testSuites != null) {
            return;
        }
        try (InputStream fis = this.xunitReportXmlFile.getInputStream();){
            Document doc = this.documentBuilder.parse(fis);
            this.testSuites = doc.getElementsByTagName(TESTSUITE_TAG);
        }
        catch (IOException | SAXException e) {
            throw new ImportFailedException(String.format("Unable to parse file [%s]: %s", this.xunitReportXmlFile, e.getMessage()), (Throwable)e);
        }
        if (this.testSuites.getLength() == 0) {
            throw new NothingToImportException(String.format("Nothing to import for file [%s]: No test suites found.", this.xunitReportXmlFile));
        }
    }

    private void createEventsForTestResults(Element testSuite, UUID testRunId, EventHandler eventHandler, String testResultFilename) throws ImportException {
        String prefix = (Strings.isNullOrEmpty((String)this.moduleName) ? "" : this.moduleName + ";") + XUnitReportXmlImporter.formatSuiteName(testSuite.getAttribute("name"));
        NodeList testCases = testSuite.getElementsByTagName(TESTCASE_TAG);
        int length = testCases.getLength();
        for (int i = 0; i < length; ++i) {
            Element testCase = (Element)testCases.item(i);
            TestCaseResult testCaseResult = this.testCaseResult(testCase);
            if (testCaseResult.passed) {
                ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"functionalResult", (Map)Event.props((Object[])new Object[]{"result", "PASSED", "duration", this.getDurationInMilliseconds(testCase), "name", prefix + ";" + testCase.getAttribute("name"), "fileName", testResultFilename}));
                continue;
            }
            ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"functionalResult", (Map)Event.props((Object[])new Object[]{"result", "FAILED", "duration", this.getDurationInMilliseconds(testCase), "name", prefix + ";" + testCase.getAttribute("name"), "fileName", testResultFilename, "firstError", testCaseResult.firstError}));
        }
    }

    private TestCaseResult testCaseResult(Element testCase) {
        NodeList failureNodes = testCase.getElementsByTagName("failure");
        if (failureNodes == null || failureNodes.getLength() == 0) {
            failureNodes = testCase.getElementsByTagName("error");
        }
        if (failureNodes == null || failureNodes.getLength() == 0) {
            return TestCaseResult.PASSED();
        }
        Node firstError = failureNodes.item(0).getAttributes().getNamedItem("message");
        return TestCaseResult.FAILED(firstError != null ? firstError.getNodeValue() : failureNodes.item(0).getTextContent());
    }

    private int getDurationInMilliseconds(Element testCase) {
        String duration = testCase.getAttribute("time");
        if (duration == null || "".equals(duration)) {
            return 0;
        }
        Float f = Float.valueOf(Float.parseFloat(duration));
        return (int)(f.floatValue() * 1000.0f);
    }

    private long getLastModifiedInMilliseconds(Element testCase) {
        String timestamp = testCase.getAttribute("timestamp");
        if (timestamp == null || "".equals(timestamp)) {
            return 0L;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy hh:mm:ss Z");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return format.parse(timestamp).getTime();
        }
        catch (ParseException e) {
            return this.isoDateTimeFormatter.withZoneUTC().parseMillis(timestamp);
        }
    }

    static String formatSuiteName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        String packageName = name.substring(0, lastDot);
        String className = name.substring(lastDot + 1);
        if (Strings.isNullOrEmpty((String)packageName) || Strings.isNullOrEmpty((String)className)) {
            return name;
        }
        return packageName + ";" + className;
    }

    private static class TestCaseResult {
        private final boolean passed;
        private final String firstError;

        private TestCaseResult(boolean passed, String firstError) {
            this.passed = passed;
            this.firstError = firstError;
        }

        private static TestCaseResult PASSED() {
            return new TestCaseResult(true, null);
        }

        private static TestCaseResult FAILED(String firstError) {
            return new TestCaseResult(false, firstError);
        }
    }
}

