package com.xebialabs.xltest.xunit;

import java.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.OverthereFileComparator;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;

public class XUnitTestTool extends BaseTestTool {
    private final static Logger LOG = LoggerFactory.getLogger(XUnitTestTool.class);

    public static final String TOOL_NAME = "xUnit";

    @Override
    public String getName() {
        return TOOL_NAME;
    }

    @Override
    public String getCategory() {
        return TestToolCategory.FUNCTIONAL;
    }

    @Override
    public SortedSet<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher) {
        Collection<OverthereFile> testResultFiles = super.findTestResultPaths(searchRoot, fileMatcher);
        SortedSet<OverthereFile> testResultDirectories = new TreeSet<>(new OverthereFileComparator());
        for (OverthereFile resultFile : testResultFiles) {
            testResultDirectories.add(resultFile.getParentFile());
        }
        return testResultDirectories;
    }

    @Override
    public List<Importable> findImportables(final OverthereFile searchPath, final FileMatcher fileMatcher) throws ImportException {
        return Arrays.asList(findLatestImportable(searchPath, fileMatcher));
    }

    @Override
    public Importable findLatestImportable(OverthereFile searchPath, FileMatcher fileMatcher) throws ImportException {
        LOG.debug("findLatestImportable({},{})", searchPath.getPath(), fileMatcher);
        Collection<OverthereFile> testResultFiles = globFiles(searchPath, fileMatcher);

        return new XUnitImporter(searchPath, fileMatcher.toString(), testResultFiles);
    }

    @Override
    public String getDefaultSearchPattern() {
        return "**/TEST-*.xml";
    }
}
