/*
 * Decompiled with CFR 0.152.
 */
package net.conjur.util.rs;

import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import net.conjur.api.AuthnProvider;
import net.conjur.api.Token;
import net.conjur.util.Args;

public class TokenAuthFilter
implements ClientRequestFilter {
    private static final int EXPIRATION_TIME_BUFFER = 120;
    private static final String HEADER = "Authorization";
    private final AuthnProvider authn;
    private Token currentToken;

    public TokenAuthFilter(AuthnProvider authn) {
        this.authn = Args.notNull(authn);
    }

    public void filter(ClientRequestContext rc) throws IOException {
        if (!this.isTokenValid()) {
            this.currentToken = this.authn.authenticate();
        }
        rc.getHeaders().putSingle((Object)HEADER, (Object)this.currentToken.toHeader());
    }

    private boolean isTokenValid() {
        return this.currentToken != null && !this.currentToken.willExpireWithin(120);
    }
}

